import java.util.Vector;

import vtk.vtkMath;
import vtk.vtkPointSet;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkProgrammableFilter;
import vtk.vtkStructuredGrid;

public class MyFilter2 extends vtkProgrammableFilter {

	private vtkPoints points;
	private vtkPolyData out_struct;

	@SuppressWarnings("unused")
	private void executeFilter() {
		vtkPolyData input_struct = GetPolyDataInput();
		out_struct = GetPolyDataOutput();
		// init out
		out_struct.CopyStructure(input_struct);
		out_struct.GetPointData().PassData(input_struct.GetPointData());
		out_struct.GetCellData().PassData(input_struct.GetCellData());
		out_struct.SetPoints(points);
		
		if (GetPolyDataInput().GetMTime() > GetMTime()) {
			System.out.println("executeFilter");
			points = new vtkPoints();
			int numberOfPoints = input_struct.GetNumberOfPoints();
			points.SetNumberOfPoints(numberOfPoints);
			out_struct.SetPoints(points);
			for (int i = 0; i < numberOfPoints; i++) {
				points.SetPoint(i, input_struct.GetPoint(i));
			}
		}
	}

	public void doPick(int id) {
		System.out.println("doPick");
		double[] point = { 0, 0, 0 };
		points.SetPoint(id, point);
		Modified();
	}

	public MyFilter2() {
		SetExecuteMethod(this, "executeFilter");
	}

}
